/*------------------------------------------------------------------------------
						SinCity (by Shaduy)
------------------------------------------------------------------------------*/

float4 SinCityPass( float4 colorInput )
{
    colorInput = pow(colorInput, .45f);
    float3 bwcolor = dot(colorInput.rgb, 1.f.xxx) * 0.33333f;
    float weight = smoothstep(0.1f, 0.25f, colorInput.r - bwcolor);
    bwcolor = pow(bwcolor * 1.1f, 2.f);
    float3 colorout = lerp(bwcolor, colorInput * float3(1.1f, 0.5f, 0.5f), weight);
    return pow(float4(colorout, 1.f), 2.2f);
}